/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.tests.dao;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IDao;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.GenericStepVO;
import com.quantumdata.sct.dao.vo.InputStepVO;
import com.quantumdata.sct.dao.vo.OptionElementVO;
import com.quantumdata.sct.dao.vo.OptionStepVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.ServiceStepVO;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class StepDAOTest
extends TestCase {
    private IDao dao = null;
    private boolean bInitialize = false;

    public StepDAOTest(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            this.dao = XMLDAOFactory.getStepDAO();
            this.bInitialize = true;
        }
        catch (Exception exception) {
            this.bInitialize = false;
        }
    }

    public void printGenericVO(GenericStepVO genericStepVO) {
        System.out.println(genericStepVO.getId());
        System.out.println(genericStepVO.getLastUpdate());
        System.out.println(genericStepVO.getDescription());
        Collection collection = genericStepVO.getParameters();
        for (ParameterVO parameterVO : collection) {
            System.out.println(parameterVO.getName());
        }
    }

    public void printCompositeVO(CompositeStepVO compositeStepVO) {
        System.out.println(compositeStepVO.getId());
        System.out.println(compositeStepVO.getLastUpdate());
        System.out.println(compositeStepVO.getDescription());
        Collection collection = compositeStepVO.getParameters();
        for (Object object : collection) {
            System.out.println(((ParameterVO)object).getName());
        }
        for (AbstractStepVO abstractStepVO : compositeStepVO.getChildStepsList()) {
            this.printElem(abstractStepVO);
        }
    }

    public void printServiceStepVO(ServiceStepVO serviceStepVO) {
        System.out.println(serviceStepVO.getId());
        System.out.println(serviceStepVO.getLastUpdate());
        System.out.println(serviceStepVO.getDescription());
        Collection collection = serviceStepVO.getParameters();
        for (ParameterVO parameterVO : collection) {
            System.out.println(parameterVO.getName());
        }
        System.out.println(serviceStepVO.getServiceName());
    }

    public void printOptionStepVO(OptionStepVO optionStepVO) {
        Object object2;
        System.out.println(optionStepVO.getId());
        System.out.println(optionStepVO.getLastUpdate());
        System.out.println(optionStepVO.getDescription());
        Collection collection = optionStepVO.getParameters();
        for (Object object2 : collection) {
            System.out.println(((ParameterVO)object2).getName());
        }
        object2 = optionStepVO.getOptionElements();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            OptionElementVO optionElementVO = (OptionElementVO)iterator.next();
            System.out.println(optionElementVO.getOptionChoiceId());
            System.out.println(optionElementVO.isIfSelected());
        }
    }

    public void printInputStepVO(InputStepVO inputStepVO) {
        System.out.println(inputStepVO.getId());
        System.out.println(inputStepVO.getLastUpdate());
        System.out.println(inputStepVO.getDescription());
        Collection collection = inputStepVO.getParameters();
        for (ParameterVO parameterVO : collection) {
            System.out.println(parameterVO.getName());
        }
    }

    public void printElem(AbstractStepVO abstractStepVO) {
        if (abstractStepVO instanceof CompositeStepVO) {
            this.printCompositeVO((CompositeStepVO)abstractStepVO);
        } else if (abstractStepVO instanceof GenericStepVO) {
            this.printGenericVO((GenericStepVO)abstractStepVO);
        } else if (abstractStepVO instanceof ServiceStepVO) {
            this.printServiceStepVO((ServiceStepVO)abstractStepVO);
        } else if (abstractStepVO instanceof OptionStepVO) {
            this.printOptionStepVO((OptionStepVO)abstractStepVO);
        } else if (abstractStepVO instanceof InputStepVO) {
            this.printInputStepVO((InputStepVO)abstractStepVO);
        }
    }

    public void readAllTest() {
        boolean bl = false;
        try {
            IPersistable[] iPersistableArray = this.dao.readAll();
            System.out.println(iPersistableArray.length);
            if (iPersistableArray.length > 0) {
                for (int i = 0; i < iPersistableArray.length; ++i) {
                    IPersistable iPersistable = iPersistableArray[i];
                    this.printElem((AbstractStepVO)((Object)iPersistable));
                }
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        StepDAOTest.assertEquals(bl, false);
    }

    public void readTest() {
        boolean bl = false;
        String string = "ID1";
        try {
            IPersistable iPersistable = this.dao.read(string);
            bl = !iPersistable.getId().equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        StepDAOTest.assertEquals(bl, false);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new StepDAOTest("readTest"));
        testSuite.addTest(new StepDAOTest("readAllTest"));
        return testSuite;
    }
}

